IF  EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[TRG_VALIDA_VERSAO]'))
	DROP TRIGGER [dbo].[TRG_VALIDA_VERSAO]
GO

CREATE TRIGGER [dbo].[TRG_VALIDA_VERSAO]  ON  [dbo].[PRC_SISTEMAS_CTR_VERSAO]
   FOR INSERT, UPDATE
AS 
BEGIN
	SET NOCOUNT ON;
	DECLARE @SISTEMA			AS NVARCHAR(40),
			@VERSAO 			AS NVARCHAR(40),
			@CD_USU 			AS INT,
			@MSG_ERRO 			AS NVARCHAR(50),
			@AuxQuery 			AS NVARCHAR(300),
			@SelectedVersion 	AS INT,
			@NewVersion 		AS INT,
			@NewestVersion 		AS INT;
			
	SELECT 
		@SISTEMA  = SISTEMA,
		@VERSAO  = VERSAO,
		@CD_USU	 = CD_USU
	FROM 
		INSERTED I ;
		
	/*IF LEFT(@VERSAO, 4) <>  '04.0'
	BEGIN
		RETURN;	--Desativada temporariamente por ter mudada a versao para 4.08
	END 
	*/
	IF @CD_USU =1	/* Permite o usuário 1 a fazer tudo */
	BEGIN
		RETURN;	
	END
	 
	IF @SISTEMA LIKE '%PRECIFICACAO%'
		  SET @SISTEMA ='PRECIFICACAO'
	
	SET @NewVersion = CONVERT(int, dbo.F_LIMPA_NUMEROS(@VERSAO)); /* Transforma a versão para INT */
	
	SET @AuxQuery = 'SELECT @SelectedVersion = (SELECT TOP 1 CONVERT(INT, dbo.F_LIMPA_NUMEROS(' + @SISTEMA + ')) FROM  PRC_SISTEMAS_VERSAO)'; /* Obtem a versao que atual */
	EXEC sp_executesql  @AuxQuery,
						N'@SelectedVersion INT OUTPUT', 
						@SelectedVersion = @SelectedVersion OUTPUT; 
						
	SET @AuxQuery = 'SELECT @NewestVersion = (SELECT CONVERT(INT, dbo.F_LIMPA_NUMEROS( MAX(VERSAO))) FROM  PRC_SISTEMAS_CTR_VERSAO WHERE CD_USU <> 1  and left (versao,3)=''04.'' AND SISTEMA = '''+ @SISTEMA + ''')' /* Obtem a versao mais atualizada utilizada */
	EXEC sp_executesql  @AuxQuery,
						N'@NewestVersion INT OUTPUT',
						@NewestVersion = @NewestVersion OUTPUT;

	IF (@SelectedVersion <> 0)	/* Verifica se foi passada versao */
	BEGIN
		IF (@NewVersion <> @SelectedVersion)	/* Impede utilizar versao diferente da selecionada */
		BEGIN
			RAISERROR ('VERSAO DO SISTEMA INVALIDA.',16, 1);
			RETURN;
		END
		ELSE IF (@NewVersion < @NewestVersion) /* Impede versões anteriores a mais atualizada já utilizada */
		BEGIN
			SET @MSG_ERRO = 'VERSAO DO SISTEMA NAO PODE SER INFERIOR A ' + CONVERT(VARCHAR,@NewestVersion) + '.';
			RAISERROR (@MSG_ERRO,16, 1);   
			RETURN;
		END
		RETURN;
	END
END

-------------------------
--FARMAGOI-3685
-------------------------